#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <limits.h>
#include <string.h>

#define MAX_N 305

typedef struct {
    int id;
    long long w;
    long long v;
    long long v_skalirana; 
} Ponco;

Ponco poncoi[MAX_N];
long long W_max;
double epsilon;
int N_poncoa;

#define MAX_V_SKALIRANA 9000001
long long dp[MAX_V_SKALIRANA];

int izbor[MAX_V_SKALIRANA];
int izabrani_poncoi[MAX_N];

long long min_ll(long long a, long long b) {
    return (a < b) ? a : b;
}

void resi_problem() {
    long long V_max_pojedinacno = 0;
    
    for (int i = 0; i < N_poncoa; i++) {
        if (poncoi[i].v > V_max_pojedinacno) {
            V_max_pojedinacno = poncoi[i].v;
        }
    }

    if (V_max_pojedinacno == 0) {
        printf("0\n\n");
        return;
    }

    double S = (epsilon * V_max_pojedinacno) / N_poncoa;

    if (S < 1.0) {
         S = 1.0;
    }

    long long V_max_skalirana_ukupno = 0;
    for (int i = 0; i < N_poncoa; i++) {
        poncoi[i].v_skalirana = (long long)floor(poncoi[i].v / S);
        V_max_skalirana_ukupno += poncoi[i].v_skalirana;
    }

    if (V_max_skalirana_ukupno >= MAX_V_SKALIRANA) {
         V_max_skalirana_ukupno = MAX_V_SKALIRANA - 1;
    }
    
    for (long long v = 1; v <= V_max_skalirana_ukupno; v++) {
        dp[v] = W_max + 1;
        izbor[v] = -1;
    }
    dp[0] = 0;
    izbor[0] = -2;

    for (int i = 0; i < N_poncoa; i++) {
        long long w = poncoi[i].w;
        long long v_prime = poncoi[i].v_skalirana;
        
        for (long long v = V_max_skalirana_ukupno; v >= v_prime; v--) {
            if (dp[v - v_prime] + w <= W_max) {
                if (dp[v - v_prime] + w < dp[v]) {
                    dp[v] = dp[v - v_prime] + w;
                    izbor[v] = i;
                }
            }
        }
    }

    long long max_v_nadjen = 0;
    for (long long v = V_max_skalirana_ukupno; v >= 0; v--) {
        if (dp[v] <= W_max) {
            max_v_nadjen = v;
            break;
        }
    }
    
    int br_izabranih = 0;
    long long trenutna_v = max_v_nadjen;
    
    while (trenutna_v > 0 && izbor[trenutna_v] != -1) {
        int i = izbor[trenutna_v];
        if (i == -2) break;
        
        izabrani_poncoi[br_izabranih++] = poncoi[i].id;
        trenutna_v -= poncoi[i].v_skalirana;
        
        if (trenutna_v < 0) break; 
    }

    printf("%d\n", br_izabranih);
    for (int i = 0; i < br_izabranih; i++) {
        printf("%d%c", izabrani_poncoi[i], (i == br_izabranih - 1) ? ' ' : ' ');
    }
    printf("\n");
}

int main() {
    if (scanf("%d %lld %lf", &N_poncoa, &W_max, &epsilon) != 3) return 1;

    for (int i = 0; i < N_poncoa; i++) {
        if (scanf("%lld %lld", &poncoi[i].w, &poncoi[i].v) != 2) return 1;
        poncoi[i].id = i + 1;
    }

    resi_problem();

    return 0;
}